/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice.post;

import com.android.invoice.domain.model.AInvoiceDto;
import com.android.payment.domain.model.ACheckDto;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.GetIdentity;
import com.utility.TncJdbc;
import org.springframework.stereotype.Service;

@Service
public class InsertAInvoice {
    private final DbConnection dbConnection;

    public long invoke(AInvoiceDto dto) {
        String nextCustomCode = this.findNextCustomCode(dto);
        String insertPart = "INSERT INTO TmpFacture(FType, FDateTime, C_Code, C_CodeVaseteh, Comment, \n Takhfif, visitorDiscountPrice, serverDiscountPrice, serverCommissionPrice, UserCode, \n Fac_code_c, TasviehDate, FNaghd, FNesiyeh, FCheck, FCard, FNaghdSarfasl, FCardSarfasl,SumLevy, Kind) ";
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate();
        LoginDto login = jdbc.getLogin();
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        double chequeAmount = 0.0;
        if (dto.getChequeList() != null) {
            chequeAmount = dto.getChequeList().stream().mapToDouble(ACheckDto::getAmount).sum();
        }
        jdbc.update("INSERT INTO TmpFacture(FType, FDateTime, C_Code, C_CodeVaseteh, Comment, \n Takhfif, visitorDiscountPrice, serverDiscountPrice, serverCommissionPrice, UserCode, \n Fac_code_c, TasviehDate, FNaghd, FNesiyeh, FCheck, FCard, FNaghdSarfasl, FCardSarfasl,SumLevy, Kind)  VALUES(" + ConvertStr.getValuesQuestionMarksBasedOnInsertColNum((String)"INSERT INTO TmpFacture(FType, FDateTime, C_Code, C_CodeVaseteh, Comment, \n Takhfif, visitorDiscountPrice, serverDiscountPrice, serverCommissionPrice, UserCode, \n Fac_code_c, TasviehDate, FNaghd, FNesiyeh, FCheck, FCard, FNaghdSarfasl, FCardSarfasl,SumLevy, Kind) ") + ")", new Object[]{dto.getAInvoiceTypeName().getTypeChar(), dto.getInvoiceDate(), dto.getPartyCode(), settingLoader.getMidManId(), dto.getDescription(), dto.getDiscountPrice(), dto.getVisitorDiscountPrice(), dto.getServerDiscountPrice(), dto.getServerCommissionPrice(), jdbc.getLogin().getUserCodeInc(), nextCustomCode, dto.getSettlementDate(), dto.getCashAmount(), dto.getCreditAmount(), chequeAmount, dto.getPosAmount(), dto.getCashRegHeading(), dto.getAccountHeading(), dto.getTaxSum(), dto.getKind()});
        return GetIdentity.invoke((TncJdbc)jdbc);
    }

    private String findNextCustomCode(AInvoiceDto dto) {
        String nextCustomCode = (String)this.dbConnection.getJdbcTemplate().queryForObject("Select Isnull(MAX(Fac_Code_c),0) + 1 \n FROM TmpFacture WITH(noLock) \n WHERE FType = '" + dto.getAInvoiceTypeName().getTypeChar() + "' \n And Cast(FDateTime as date) = '" + dto.getInvoiceDate() + "'", String.class);
        return !ConvertStr.isNullOrEmpty((String)nextCustomCode) ? nextCustomCode : "1";
    }

    public InsertAInvoice(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

